using System;
using System.IO;
using System.Windows.Forms;
using System.Threading;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;
using BeWise.SharpBuilderTools.Ant;
using BeWise.SharpBuilderTools.Utils;
using System.Text.RegularExpressions;

namespace BeWise.SharpBuilderTools
{
	public class OTAAnt : BaseOTA
	{
		/**************************************************************/
		/*                        Private
		/**************************************************************/

		private static String[] fSelectedTargets;
		private static string fMsg = "";
		private static BaseAnt fCurrentAnt = null;

		/**************************************************************/
		/*                       Protected
		/**************************************************************/

		protected void RunAnt() {
			try {
				if (CurrentAnt.AntPath == "" || !File.Exists(CurrentAnt.AntExe)) {
					MessageBox.Show("Please configure Sharp Builder Tools (Ant paths)", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
				else {
					IOTAMessageService _MessageService = (IOTAMessageService) BorlandIDE.GetService(typeof(IOTAMessageService));
					_MessageService.ShowMessageView(null);
					IntPtr _Unknown;

					_MessageService.AddCompilerMessage("", "Running " + CurrentAnt.Name, CurrentAnt.Name, OTAMessageKind.otamkInfo, 0, 0, new IntPtr(0), out _Unknown);
					fMsg= "";

					CurrentAnt.Run(fSelectedTargets, Path.GetDirectoryName(Project.FileName));
				}
			}
			catch (Exception e) {
				MessageBox.Show(e.Message + "--" + e.StackTrace);
			}
		}

		protected static void DoRunCompleted(object aSender, EventArgs e) {
			DoRefreshConsole("/n");
		}

		protected static void DoRefreshConsole(string aStr) {
			fMsg += aStr;
			StringReader  _Reader = new StringReader(fMsg);

			string _Line = _Reader.ReadLine();
			string _PreviousLine = "";

			while (_Line != null) {
				_PreviousLine = _Line;
				_Line = _Reader.ReadLine();

				if (_Line != null) {
					AddMessage(_PreviousLine);
				}
				else if (aStr.EndsWith("\r") || aStr.EndsWith("\n")) {
					AddMessage(_PreviousLine);
					_PreviousLine = "";
				}


			}

			fMsg = _PreviousLine;
		}

		protected static void AddMessage(string aText) {
			IOTAMessageService _MessageService = (IOTAMessageService) BorlandIDE.GetService(typeof(IOTAMessageService));
			string _FileName = "";
			int _LineNumber = 0;
			int _ColNumber = 0;
			OTAMessageKind _OTAMessageKind = OTAMessageKind.otamkInfo;
			IntPtr _Out;

			_MessageService.ShowMessageView(null);

			Regex _Regex = new Regex(@"\s*(?<FileName>.+)\((?<Line>\d+),\s*(?<Col>\d+)\)\:",
								RegexOptions.IgnoreCase |
								RegexOptions.Multiline |
								RegexOptions.IgnorePatternWhitespace |
								RegexOptions.Compiled);

			Match _Match = _Regex.Match(aText);

			if (_Match.Success) {
				_FileName = _Match.Groups[1].Value;
				_LineNumber = int.Parse(_Match.Groups[2].Value);
				_ColNumber = int.Parse(_Match.Groups[3].Value);
				//_OTAMessageKind = OTAMessageKind.otamkError;
			}

			_MessageService.AddCompilerMessage(_FileName,
											   aText,
											   CurrentAnt.Name,
											   _OTAMessageKind,
											   _LineNumber,
											   _ColNumber,
											   new IntPtr(0),
											   out _Out);
		}

		protected BaseAntProject GetAntProject() {
			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				IOTAProject _Project = _ProjectGroup.ActiveProject;

				if (_Project != null) {
					for (int k = 0; k < _Project.ModuleCount; k++) {
						IOTAModuleInfo _ModuleInfo = _Project.GetModuleInfo(k);

						if (CurrentAnt.IsAntFile(_ModuleInfo.FileName)) {
							return CurrentAnt.CreateAntProject(_ModuleInfo.FileName);
						}
					}
				}
			}

			MessageBox.Show("No " + CurrentAnt.Name  + " Project found in the active project!", Consts.MESSAGE_BOX_TITLE, MessageBoxButtons.OK, MessageBoxIcon.Information);

			return null;
		}

		/**************************************************************/
		/*                        Public
		/**************************************************************/

		public void DoSingleAnt(object aSender, EventArgs aEventArgs)
		{
			try {
			FrmNAntRunner _Frm = new FrmNAntRunner();

			if (Project != null) {
				_Frm.Project = Project;

				if (_Frm.ShowDialog() == DialogResult.OK) {
					fSelectedTargets = new String[] {_Frm.SelectedTarget};

					Thread _T = new Thread(new ThreadStart(RunAnt));
					_T.Start();
				}
			}
			}
			catch (Exception e) {
				MessageBox.Show(e.Message + "--" + e.StackTrace);
			}
		}

		public void DoMultipleAnt(object aSender, EventArgs aEventArgs)
		{
			FrmNAntMultipleRunner _Frm = new FrmNAntMultipleRunner();

			if (Project != null) {
				_Frm.Project = Project;

				if (_Frm.ShowDialog() == DialogResult.OK) {
					fSelectedTargets = _Frm.SelectedTargets;

					Thread _T = new Thread(new ThreadStart(RunAnt));
					_T.Start();
				}
			}
		}

		public void DoLastAnt(object aSender, EventArgs aEventArgs)
		{
			if (fSelectedTargets.Length > 0) {

				Thread _T = new Thread(new ThreadStart(RunAnt));
				_T.Start();
			}
			else {
				DoSingleAnt(aSender, aEventArgs);
			}
		}

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

			// Sep1
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "Sep1",
												 "-");

			// Single Ant
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "SingleAntMenu",
												 "Run " + CurrentAnt.Name + " Target...");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoSingleAnt);

			// Multiple Ant
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "MultipleAntMenu",
												 "Run Multiple " + CurrentAnt.Name + " Target...");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoMultipleAnt);

			// Last Ant
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "LastAntMenu",
												 "Run Last " + CurrentAnt.Name + " Target...");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoLastAnt);

			aMenuNames = new string[] {"SingleAntMenu", "MultipleAntMenu", "LastAntMenu"};
			aMenuShortCuts = new int[] {16505, 8313, 121};

			SetMenuText();
		}


		public static void SetMenuText() {
			IOTAMainMenuService _MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));
			IOTAMenuItem _MenuItem = null;

			_MenuItem = _MenuService.GetMenuItem("SingleAntMenu");

			if (_MenuItem != null){
				_MenuItem.Text = "Run " + CurrentAnt.Name + " Target...";
			}

			_MenuItem = _MenuService.GetMenuItem("MultipleAntMenu");

			if (_MenuItem != null){
				_MenuItem.Text = "Run Multiple " + CurrentAnt.Name + " Target...";
			}

			_MenuItem = _MenuService.GetMenuItem("LastAntMenu");

			if (_MenuItem != null){
				_MenuItem.Text = "Run Last " + CurrentAnt.Name + " Target...";
			}
		}

		// *************************************************************************
		//                            Properties
		// *************************************************************************

		public BaseAntProject Project {
			get {
				return GetAntProject();
			}
		}

		public static BaseAnt CurrentAnt {
			get {

				if (Main.Configuration.UseAnt) {
					if (fCurrentAnt == null || fCurrentAnt is NAnt) {
						fCurrentAnt = new BeWise.SharpBuilderTools.Ant.Ant();
						fCurrentAnt.OnConsoleOutput += new RunProcess.ConsoleOutputEvent(DoRefreshConsole);
						fCurrentAnt.OnRunCompleted += new EventHandler(DoRunCompleted);
					}
				} else {
					if (fCurrentAnt == null || fCurrentAnt is BeWise.SharpBuilderTools.Ant.Ant) {
						fCurrentAnt = new NAnt();
						fCurrentAnt.OnConsoleOutput += new RunProcess.ConsoleOutputEvent(DoRefreshConsole);
						fCurrentAnt.OnRunCompleted += new EventHandler(DoRunCompleted);
					}
				}

				return fCurrentAnt;
			}
		}
	}
}
